/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8281;

import ibm.nways.jdm.DestinationPropBook;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.common.IPAddress;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.NotSupported;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.eui.JDMWizardInfo;
import ibm.nways.jdm.eui.JDMWizardPanelDelegate;
import ibm.nways.jdm.eui.MessageBox;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.ras.RAS;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;

public class AllCreateCurrent
implements JDMWizardPanelDelegate {
    private static ResourceBundle myResources = ResourceBundle.getBundle("ibm.nways.jdm8281.Resources");
    private static int MaxRows = 10;
    DestinationPropBook myBook;
    JdmBrowser browser;
    GenModel device_Model;
    NavigationContext myContext;
    MessageBox messageToUser;
    private static final int RASID = 19;
    private static final int RASSUB = 12;

    public void setDefaults(JDMWizardInfo jDMWizardInfo) {
        if (RAS.isEnabled(19, 12)) {
            RAS.trace(19, 12, this, "setDefaults", "entering setDefaults()");
        }
        IPAddress iPAddress = new IPAddress("0.0.0.0");
        IPAddress iPAddress2 = new IPAddress("255.255.255.255");
        Hashtable hashtable = jDMWizardInfo.getItems();
        hashtable.put("newIpAddress", iPAddress);
        hashtable.put("newSubnetMask", iPAddress2);
        hashtable.put("newCommunity", "");
    }

    public boolean abort(JDMWizardInfo jDMWizardInfo) {
        return true;
    }

    public boolean proceed(JDMWizardInfo jDMWizardInfo) {
        boolean bl = true;
        GenModel genModel = null;
        ModelInfo modelInfo = null;
        int n = 0;
        String string = null;
        Hashtable hashtable = null;
        if (RAS.isEnabled(19, 12)) {
            RAS.trace(19, 12, this, "proceed", "proceed");
        }
        long l = System.currentTimeMillis();
        this.myBook = (DestinationPropBook)jDMWizardInfo.getPropertyBook();
        if (this.browser == null && this.myBook != null) {
            this.browser = (JdmBrowser)this.myBook.getBrowser();
        }
        if (this.browser == null) {
            if (RAS.isEnabled(19, 12)) {
                RAS.trace(19, 12, this, "proceed", "8281: No browser available");
            }
            bl = false;
        }
        if (bl) {
            if (this.device_Model == null) {
                this.device_Model = (GenModel)this.browser.getModel();
            }
            try {
                genModel = jDMWizardInfo.getModel();
                Vector vector = genModel.getRestOfInfo("Panel", "default", null, null);
                n = vector.size() + 1;
                if (n >= MaxRows) {
                    if (RAS.isEnabled(19, 12)) {
                        RAS.trace(19, 12, this, "proceed", "DL: Create - Table Full");
                    }
                    string = new String("WZ_TableFull");
                    bl = false;
                }
                int n2 = 1;
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    modelInfo = (ModelInfo)enumeration.nextElement();
                    Serializable serializable = modelInfo.get("Index.AtmBrAuthIndex");
                    if (serializable instanceof Integer && (Integer)serializable > n2) {
                        n = n2;
                        break;
                    }
                    Serializable serializable2 = modelInfo.get("Panel.AtmBrAuthIpAddress");
                    if (serializable2 instanceof NotSupported) {
                        n = n2;
                        break;
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                if (RAS.isEnabled(19, 12)) {
                    RAS.trace(19, 12, this, "proceed", "DL: Table Create - can't get model/info to get nextFreeIndex for row creation");
                }
                RAS.logException(19, 12, this, "proceed", exception);
                string = new String("WZ_getError");
                bl = false;
            }
        }
        if (bl) {
            if (RAS.isEnabled(19, 12)) {
                RAS.trace(19, 12, this, "proceed", "### Creating row  " + n);
            }
            genModel = jDMWizardInfo.getModel();
            modelInfo = new ModelInfo();
            hashtable = jDMWizardInfo.getItems();
            modelInfo.add("Index.AtmBrAuthIndex", new Integer(n));
            modelInfo.add("Panel.AtmBrAuthIpAddress", (Serializable)hashtable.get("newIpAddress"));
            modelInfo.add("Panel.AtmBrAuthSubnetMask", (Serializable)hashtable.get("newSubnetMask"));
            modelInfo.add("Panel.AtmBrAuthCommunity", (Serializable)hashtable.get("newCommunity"));
            try {
                modelInfo = genModel.setInfo("Panel", modelInfo);
                bl = this.checkSnmpResponse(modelInfo);
                if (!bl) {
                    string = new String("WZ_badSet");
                }
            }
            catch (Exception exception) {
                bl = false;
                string = new String("WZ_badSet");
                if (RAS.isEnabled(19, 12)) {
                    RAS.trace(19, 12, this, "getNavTreeRoot", "DL: Exception creating row of table");
                }
                RAS.logException(19, 12, this, "proceed", exception);
            }
        }
        if (!bl && this.browser != null) {
            this.browser.displayMsg(AllCreateCurrent.getNLSString(string));
            this.messageToUser = new MessageBox(this.browser.getFrame(), AllCreateCurrent.getNLSString("TC_error"), AllCreateCurrent.getNLSString(string), true);
        }
        long l2 = System.currentTimeMillis();
        if (RAS.isEnabled(19, 12)) {
            RAS.trace(19, 12, this, "proceed", " Finished proceed() " + String.valueOf(l2 - l) + " msecs");
        }
        return bl;
    }

    protected static String getNLSString(String string) {
        String string2 = null;
        try {
            string2 = myResources.getString(string);
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }

    private boolean checkSnmpResponse(ModelInfo modelInfo) {
        boolean bl = false;
        Enumeration enumeration = modelInfo.getItemIds();
        while (enumeration.hasMoreElements()) {
            bl = true;
            String string = (String)enumeration.nextElement();
            Serializable serializable = modelInfo.get(string);
            if (!(serializable instanceof SpecialValue)) continue;
            if (RAS.isEnabled(19, 12)) {
                RAS.trace(19, 12, this, "checkSnmpResponse", "DL: Error in snmp set. Variable is " + string + "  SpecialValue is " + serializable);
            }
            bl = false;
            break;
        }
        return bl;
    }
}

